local t = Def.ActorFrame {};
	
t[#t+1] = LoadActor("labels") .. {
		InitCommand=cmd(diffusealpha,1;);
	};
t[#t+1] = LoadActor("p2labels") .. {
		InitCommand=cmd(diffusealpha,1;);
	};

-- P1 Grade Circle
t[#t+1] = LoadActor("_gradecircle") .. {
		InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);zoom,0.6;x,SCREEN_LEFT+210;y,SCREEN_CENTER_Y-120;playcommand,"Set";);
		OnCommand=cmd(diffusealpha,0;sleep,0.3;decelerate,0.3;diffusealpha,1;zoom,0.65;accelerate,0.2;zoom,0.6;sleep,1;);
		OffCommand=cmd(sleep,0.2;decelerate,0.1;zoom,0.7;accelerate,0.2;zoom,0);
		SetCommand=function(self)
				if(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):FullComboOfScore('TapNoteScore_W3') == true) then
					self:diffuse(color("#6B9638"))
				elseif(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):FullComboOfScore('TapNoteScore_W2') == true) then
					self:diffuse(color("#FFEB3B"))
				elseif(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P1"):FullComboOfScore('TapNoteScore_W2') == true) then
					self:diffuse(color("#B3E5FC"))
		end
	end;	
};

-- P2 Grade Circle
t[#t+1] = LoadActor("_gradecircle") .. {
		InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);zoom,0.6;x,SCREEN_RIGHT-210;y,SCREEN_CENTER_Y-120;playcommand,"Set";);
		OnCommand=cmd(diffusealpha,0;sleep,0.3;decelerate,0.3;diffusealpha,1;zoom,0.65;accelerate,0.2;zoom,0.6;sleep,1;);
		OffCommand=cmd(sleep,0.2;decelerate,0.1;zoom,0.7;accelerate,0.2;zoom,0);
		SetCommand=function(self)
				if(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):FullComboOfScore('TapNoteScore_W3') == true) then
					self:diffuse(color("#6B9638"))
				elseif(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):FullComboOfScore('TapNoteScore_W2') == true) then
					self:diffuse(color("#FFEB3B"))
				elseif(STATSMAN:GetCurStageStats():GetPlayerStageStats("PlayerNumber_P2"):FullComboOfScore('TapNoteScore_W2') == true) then
					self:diffuse(color("#B3E5FC"))
		end
	end;	
};

t[#t+1] = LoadFont("_arimo Bold 24px") .. { 
          InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_1);x,SCREEN_LEFT+98;y,SCREEN_TOP+193;horizalign,left;diffuse,color("#212121");zoom,0.6;uppercase,true;playcommand,"Set";);
		  OnCommand=cmd(diffusealpha,0;addx,-10;sleep,0.5;decelerate,0.2;diffusealpha,1;addx,10;);	
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          SetCommand=function(self)
			stepsP1 = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetPlayedSteps()[1]
				if stepsP1 ~= nil then
					self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString( stepsP1:GetDifficulty())));
				else
					self:settext("")
				end
          end
};

t[#t+1] = LoadFont("_arimo Bold 24px") .. { 
          InitCommand=cmd(visible,GAMESTATE:IsHumanPlayer(PLAYER_2);x,SCREEN_RIGHT-98;y,SCREEN_TOP+193;horizalign,right;diffuse,color("#212121");zoom,0.6;uppercase,true;playcommand,"Set";);
		  OnCommand=cmd(diffusealpha,0;addx,10;sleep,0.5;decelerate,0.2;diffusealpha,1;addx,-10;);	
		  OffCommand=cmd(decelerate,0.3;diffusealpha,0;addx,10;);
          SetCommand=function(self)
			stepsP1 = STATSMAN:GetCurStageStats():GetPlayerStageStats(PLAYER_1):GetPlayedSteps()[1]
				if stepsP1 ~= nil then
					self:settext(THEME:GetString("CustomDifficulty",ToEnumShortString( stepsP1:GetDifficulty())));
				else
					self:settext("")
				end
          end
};

t[#t+1] = Def.Sprite {
		name="SongJacket";
        InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-120;visible, not GAMESTATE:IsCourseMode();playcommand,"Set";); 
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;zoom,0.8;);
		OnCommand=cmd(diffusealpha,0;smooth,0.2;diffusealpha,1);
		TransitionCommand=cmd(finishtweening;zoomx,0.0;diffusealpha,0;decelerate,0.5;zoom,1;diffusealpha,1;); 
        SetCommand=function(self) 
            local song = GAMESTATE:GetCurrentSong(); 
			if song then
                if song:HasJacket() then
                    self:Load(song:GetJacketPath())
					self:playcommand("Transition")
					self:scaletoclipped(128,128)
                elseif song:HasBanner() then
                    self:Load(song:GetBannerPath())
					self:playcommand("Transition")
                    self:scaletoclipped(220,69)
                else
                    self:Load(THEME:GetPathG("Common fallback", "banner"))
					self:scaletoclipped(128,128)
					self:playcommand("Transition")
                end
			else
				self:diffusealpha(0)
            end
        end;
		};
		
t[#t+1] = Def.Sprite {
		name="CourseBanner";
        InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y-120;visible,GAMESTATE:IsCourseMode();playcommand,"Set";); 
		OffCommand=cmd(decelerate,0.3;diffusealpha,0;zoom,0.8;);
		OnCommand=cmd(diffusealpha,0;smooth,0.2;diffusealpha,1);
		TransitionCommand=cmd(finishtweening;zoomx,0.0;diffusealpha,0;decelerate,0.5;zoom,1;diffusealpha,1;); 
        SetCommand=function(self) 
            local course = GAMESTATE:GetCurrentCourse(); 
			if course then
                if course:HasBanner() then
                    self:Load(course:GetBannerPath())
					self:playcommand("Transition")
                    self:scaletoclipped(220,69)
                else
                    self:Load(THEME:GetPathG("Common fallback", "banner"))
					self:scaletoclipped(128,128)
					self:playcommand("Transition")
                end
			else
				self:diffusealpha(0)
            end
        end;
		};
		
return t